/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TinkersCalibrationConfig {
    public static final CommonConfig COMMON;
    public static ForgeConfigSpec config;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)pair.getLeft();
        config = (ForgeConfigSpec)pair.getRight();
    }

    public static class CommonConfig {
        public final OreConfig titaniumOre;
        public final OreConfig altairiumOre;
        public final OreConfig halleiumOre;
        public final OreConfig hothiumOre;
        public final OreConfig immersedsilverOre;
        public final OreConfig magigaOre;
        public final OreConfig steamiumOre;
        public final OreConfig stellariumOre;
        public final OreConfig toniumOre;
        public final OreConfig inertwitheriumOre;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Titanium Ore Worldgen").push("titanium_ore");
            this.titaniumOre = new TitaniumOreConfig(builder);
            builder.pop();
            builder.comment("Altairium Ore Worldgen").push("altairium_ore");
            this.altairiumOre = new AltairiumOreConfig(builder);
            builder.pop();
            builder.comment("Halleium Ore Worldgen").push("halleium_ore");
            this.halleiumOre = new HalleiumOreConfig(builder);
            builder.pop();
            builder.comment("Hothium Ore Worldgen").push("hothium_ore");
            this.hothiumOre = new HothiumOreConfig(builder);
            builder.pop();
            builder.comment("Immersed Silver Ore Worldgen").push("immersedsilver_ore");
            this.immersedsilverOre = new ImmersedSilverOreConfig(builder);
            builder.pop();
            builder.comment("Inert Witherium Ore Worldgen").push("inertwitherium_ore");
            this.inertwitheriumOre = new InertwitheriumOreConfig(builder);
            builder.pop();
            builder.comment("Steamium Ore Worldgen").push("steamium_ore");
            this.steamiumOre = new SteamiumOreConfig(builder);
            builder.pop();
            builder.comment("Stellarium Ore Worldgen").push("stellarium_ore");
            this.stellariumOre = new StellariumOreConfig(builder);
            builder.pop();
            builder.comment("Magiga Ore Worldgen").push("magiga_ore");
            this.magigaOre = new MagigaOreConfig(builder);
            builder.pop();
            builder.comment("Tonium Ore Worldgen").push("tonium_ore");
            this.toniumOre = new ToniumOreConfig(builder);
            builder.pop();
        }
    }

    public static class ToniumOreConfig
    extends OreConfig {
        public ToniumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Tonium ore").define("toniumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -20, -60, 0);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", -10, -60, 20);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class StellariumOreConfig
    extends OreConfig {
        public StellariumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Stellarium ore").define("stellariumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -20, -60, 0);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", -10, -60, 20);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class SteamiumOreConfig
    extends OreConfig {
        public SteamiumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Steamium ore").define("steamiumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -20, -60, 0);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", -10, -60, 20);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class MagigaOreConfig
    extends OreConfig {
        public MagigaOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Magiga ore").define("magigaOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -20, -60, 0);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", -10, -60, 20);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class InertwitheriumOreConfig
    extends OreConfig {
        public InertwitheriumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Inertwitherium ore").define("inertwitheriumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", 5, 0, 60);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", 10, 2, 85);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 8, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 7);
        }
    }

    public static class ImmersedSilverOreConfig
    extends OreConfig {
        public ImmersedSilverOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable ImmersedSilver ore").define("immersedSilverOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", 30, 10, 50);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", 40, 20, 70);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class HothiumOreConfig
    extends OreConfig {
        public HothiumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Hothium ore").define("hothiumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", 10, -10, 50);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", 30, 20, 60);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class HalleiumOreConfig
    extends OreConfig {
        public HalleiumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Halleium ore").define("halleiumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -20, -60, 0);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", -10, -60, 20);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class AltairiumOreConfig
    extends OreConfig {
        public AltairiumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Altairium ore").define("altairiumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", 10, -10, 50);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", 30, 20, 60);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class TitaniumOreConfig
    extends OreConfig {
        public TitaniumOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Titanium ore").define("titaniumOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -20, -60, 0);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", -10, -60, 20);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class OreConfig {
        public ForgeConfigSpec.BooleanValue enabled;
        public ForgeConfigSpec.IntValue minY;
        public ForgeConfigSpec.IntValue maxY;
        public ForgeConfigSpec.IntValue count;
        public ForgeConfigSpec.IntValue size;

        public OreConfig(ForgeConfigSpec.Builder builder) {
        }

        public boolean isEnabled() {
            return (Boolean)this.enabled.get();
        }

        public int getCount() {
            return (Integer)this.count.get();
        }

        public int getSize() {
            return (Integer)this.size.get();
        }

        public int getMaxY() {
            return (Integer)this.maxY.get();
        }

        public int getMinY() {
            return (Integer)this.minY.get();
        }
    }
}

